import {createReducer} from 'typesafe-actions';

import {
    editHotelReviewActions,
    EditReviewRequestActionsType,
    resetEditHotelReviewAction,
} from './actions';

export interface IEditReviewReducer {
    isSubmitting: boolean;
    isSuccess: boolean;
    hasError: boolean;
}

/* Initial State */
const initialState: IEditReviewReducer = {
    isSubmitting: false,
    isSuccess: false,
    hasError: false,
};

/* Reducer */
export default createReducer<IEditReviewReducer, EditReviewRequestActionsType>(
    initialState,
)
    .handleAction(editHotelReviewActions.request, state => ({
        ...state,
        isSubmitting: true,
        isSuccess: false,
        hasError: false,
    }))
    .handleAction(editHotelReviewActions.success, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: true,
            hasError: false,
        };
    })
    .handleAction(editHotelReviewActions.failure, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: false,
            hasError: true,
        };
    })
    .handleAction(resetEditHotelReviewAction, () => {
        return {
            ...initialState,
        };
    });
