import {createReducer} from 'typesafe-actions';

/* Types */
import {IConfirmedUserReactions} from './types';

import {
    addHotelReviewActions,
    AddReviewRequestActionsType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/add/actions';
import {
    editHotelReviewActions,
    EditReviewRequestActionsType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/edit/actions';
import {
    deleteHotelReviewActions,
    DeleteReviewRequestActionsType,
} from 'reducers/depreacted/hotels/hotelPage/reviews/delete/actions';

import getUpdatedTextReviews from './utilities/getUpdatedTextReviews';

import {
    HotelReviewsActionsType,
    getHotelReviewsActions,
    resetHotelReviewsAction,
    resetHotelReviewsListAction,
    setActiveKeywordAction,
    setHotelReviewReactionRequestActions,
    setHotelReviewReactionAction,
    setHotelReviewsSortingOptionAction,
} from './actions';

export interface IHotelReviewsListReducer {
    isLoading: boolean;
    isLoadingList: boolean;
    isSuccess: boolean;
    activeKeyPhrase?: string;
    confirmedReactions: IConfirmedUserReactions;
    data: any;
    currentSortingOption: any;
}

/* Initial State */
const initialState: IHotelReviewsListReducer = {
    isLoading: true,
    isLoadingList: false,
    isSuccess: false,
    activeKeyPhrase: undefined,
    confirmedReactions: {},
    data: {
        keyPhrases: [],
        textReviews: [],
        totalKeyPhraseCount: 0,
        totalTextReviewCount: 0,
        hasMore: false,
    },
    currentSortingOption: 'ETextReviewRankingType.RELEVANCE_ORG',
};

/* Reducer */
export default createReducer<
    IHotelReviewsListReducer,
    | HotelReviewsActionsType
    | AddReviewRequestActionsType
    | EditReviewRequestActionsType
    | DeleteReviewRequestActionsType
>(initialState)
    .handleAction(getHotelReviewsActions.request, state => ({
        ...state,
        isLoading: true,
        isSuccess: false,
    }))
    .handleAction(getHotelReviewsActions.success, (state, {payload}) => {
        return {
            ...state,
            isLoading: false,
            isLoadingList: false,
            isSuccess: true,
            data: {
                keyPhrases: payload.keyPhrases,
                totalKeyPhraseCount: payload.totalKeyPhraseCount,
                totalTextReviewCount: payload.totalTextReviewCount,
                textReviews: [
                    ...state.data.textReviews,
                    ...payload.textReviews,
                ],
                hasMore: payload.hasMore,
                userTextReview: payload.userTextReview,
            },
        };
    })
    .handleAction(addHotelReviewActions.success, (state, {payload}) => ({
        ...state,
        data: {
            ...state.data,
            userTextReview: payload.textReview,
        },
    }))
    .handleAction(editHotelReviewActions.success, (state, {payload}) => ({
        ...state,
        data: {
            ...state.data,
            userTextReview: payload.textReview,
        },
    }))
    .handleAction(deleteHotelReviewActions.success, state => ({
        ...state,
        data: {
            ...state.data,
            userTextReview: undefined,
        },
    }))
    .handleAction(resetHotelReviewsAction, () => initialState)
    .handleAction(resetHotelReviewsListAction, state => {
        return {
            ...state,
            isLoadingList: true,
            data: {
                ...state.data,
                textReviews: [],
            },
        };
    })
    .handleAction(setActiveKeywordAction, (state, {payload}) => {
        if (state.activeKeyPhrase !== payload) {
            return {
                ...state,
                activeKeyPhrase: payload,
            };
        }

        return state;
    })
    .handleAction(setHotelReviewReactionAction, (state, {payload}) => {
        const {data} = state;
        const {textReviews} = data;

        return {
            ...state,
            data: {
                ...data,
                textReviews: getUpdatedTextReviews(textReviews, payload),
            },
        };
    })
    .handleAction(
        setHotelReviewReactionRequestActions.success,
        (state, {payload}) => {
            const {confirmedReactions} = state;
            const {reviewId, userReaction} = payload;

            return {
                ...state,
                confirmedReactions: {
                    ...confirmedReactions,
                    [reviewId]: userReaction,
                },
            };
        },
    )
    .handleAction(setHotelReviewsSortingOptionAction, (state, {payload}) => {
        return {
            ...state,
            currentSortingOption: payload,
        };
    });
