import {
    IHotelReviewReaction,
    ITextReview,
} from 'types/hotels/hotel/IHotelTextReview';

import getTotalReviewReactionCounts from './getTotalReviewReactionCounts';

function getUpdatedTextReviews(
    textReviews: ITextReview[],
    reaction: IHotelReviewReaction,
) {
    const {reviewId, userReaction} = reaction;

    const updatedTextReviews = textReviews.map(textReview => {
        const {id} = textReview;

        if (reviewId === id) {
            const {totalLikeCount, totalDislikeCount} = textReview;
            const reactionCounts = getTotalReviewReactionCounts(
                {totalLikeCount, totalDislikeCount},
                textReview.userReaction,
                userReaction,
            );

            return {
                ...textReview,
                ...reactionCounts,
                userReaction: userReaction,
            };
        }

        return textReview;
    });

    return updatedTextReviews;
}

export default getUpdatedTextReviews;
