import {combineReducers} from 'redux';

import add, {IAddReviewReducer} from './add/reducer';
import edit, {IEditReviewReducer} from './edit/reducer';
import deleteReducer, {IDeleteReviewReducer} from './delete/reducer';
import list, {IHotelReviewsListReducer} from './list/reducer';

export interface IHotelReviewsReducer {
    add: IAddReviewReducer;
    edit: IEditReviewReducer;
    delete: IDeleteReviewReducer;
    list: IHotelReviewsListReducer;
}

export default combineReducers<IHotelReviewsReducer>({
    add,
    edit,
    delete: deleteReducer,
    list,
});
