import {matchPath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {hotelSearchService} from 'serviceProvider';

import {fetchLegacyHotelInfoActions} from './actions';

interface ILegacyHotelId {
    id?: string;
}

export const fetchLegacyHotelInfo = (req: Request): CustomThunkAction<void> => {
    return async dispatch => {
        try {
            const matchData = matchPath<ILegacyHotelId>(req.path, {
                path: `${URLs.hotel}/:id`,
            });
            const id = matchData?.params?.id ?? '';

            const legacyHotelInfoResponse = await hotelSearchService
                .provider(req && req.container)
                .getLegacyHotelInfo({id});

            dispatch(
                fetchLegacyHotelInfoActions.success(legacyHotelInfoResponse),
            );
        } catch (error) {
            dispatch(fetchLegacyHotelInfoActions.failure());
        }
    };
};
