import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {getAttributionParams} from 'projects/depreacted/hotels/utilities/getAttributionParams/getAttributionParams';

import {personalizationService} from 'serviceProvider';

import {getHotelsSuggestsActions} from './actions';

export const getHotelsSuggests = (): CustomThunkAction<void> => {
    return async (dispatch): Promise<void> => {
        try {
            const params = {
                ...getAttributionParams(),
            };

            dispatch(getHotelsSuggestsActions.request(params));

            const result = await personalizationService
                .provider()
                .getHotelsSuggests(params);

            dispatch(getHotelsSuggestsActions.success(result));
        } catch (error) {
            dispatch(getHotelsSuggestsActions.failure());
        }
    };
};
