import {IHotelsPreviousSearch} from 'types/hotels/previousSearches/IPreviousSearch';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setPreviousSearchesAction} from 'reducers/depreacted/hotels/previousSearches/actions';

import getPreviousSearchKey from 'projects/depreacted/hotels/utilities/previousSearches/getPreviousSearchKey';
import storePreviousSearches from 'projects/depreacted/hotels/utilities/previousSearches/storePreviousSearches';

const HOTELS_PREVIOUS_SEARCHES_COUNT = 3;

export default function addPreviousSearchThunkAction(
    previousSearch: IHotelsPreviousSearch,
): CustomThunkAction<void> {
    return (dispatch, getState): void => {
        const {
            hotels: {
                previousSearches: {items: currentPreviousSearches},
            },
        } = getState();

        if (!currentPreviousSearches) {
            return;
        }

        const uniqPreviousSearches = currentPreviousSearches.filter(
            currentPreviousSearch =>
                getPreviousSearchKey(currentPreviousSearch) !==
                getPreviousSearchKey(previousSearch),
        );

        const newPreviousSearches = [
            previousSearch,
            ...uniqPreviousSearches,
        ].slice(0, HOTELS_PREVIOUS_SEARCHES_COUNT);

        dispatch(setPreviousSearchesAction(newPreviousSearches));

        storePreviousSearches(newPreviousSearches);
    };
}
