import * as localStorage from 'local-storage';
import moment from 'moment';

import {IHotelsPreviousSearch} from 'types/hotels/previousSearches/IPreviousSearch';

import getActualStartDate from 'reducers/depreacted/hotels/previousSearches/thunk/utilities/getActualStartDate';

import {getNow} from 'utilities/dateUtils';
import {logError} from 'utilities/logger/logError';
import storePreviousSearches, {
    HOTELS_STORED_SEARCHES_KEY,
} from 'projects/depreacted/hotels/utilities/previousSearches/storePreviousSearches';
import {unknownErrToString} from 'utilities/error';

export default function restorePreviousSearches(): IHotelsPreviousSearch[] {
    try {
        if (typeof window === 'undefined') {
            return [];
        }

        const storedSearches = localStorage.get<IHotelsPreviousSearch[]>(
            HOTELS_STORED_SEARCHES_KEY,
        );

        if (!storedSearches) {
            return [];
        }

        const nowMoment = moment(getNow());

        return storedSearches.map(storedSearch => {
            const startDate = getActualStartDate(
                storedSearch.startDate,
                nowMoment,
            );

            return {
                ...storedSearch,
                startDate,
                endDate: startDate ? storedSearch.endDate : null,
            };
        });
    } catch (error) {
        storePreviousSearches([]);

        logError({message: unknownErrToString(error)}, error);

        return [];
    }
}
