import {batchActions} from 'redux-batched-actions';

import {IPointInfo} from 'server/api/TransformSearchApi/types/IPointInfo';
import {ITransformSearchContextRequestParams} from 'server/api/TransformSearchApi/types/ITransformSearchContextRequestParams';
import {ITransformSearchContextResponse} from 'server/api/TransformSearchApi/types/ITransformSearchContextResponse';
import {
    ESearchSuggestItemType,
    IHotelsSuggest,
} from 'types/hotels/common/ISearchSuggest';
import {IHotelsSearchFormPointField} from 'projects/depreacted/hotels/components/SearchForm/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {setHotelsSearchFormToFieldAction} from 'reducers/depreacted/hotels/searchForm/actions';

import {
    ESuggestSource,
    ISuggestValue,
} from 'components/SearchSuggest/SearchSuggest';

import {crossSearchProvider} from 'serviceProvider/common/crossSearch/crossSearchProvider';

const getHotelsSuggestFromPointInfo = (
    pointInfo: IPointInfo,
): ISuggestValue<IHotelsSuggest> => {
    return {
        inputValue: pointInfo.title,
        source: ESuggestSource.CROSS_SEARCH,
        selectedValue: {
            id: `region-${pointInfo.geoId}-${pointInfo.countryTitle}`,
            name: pointInfo.title,
            description: pointInfo.countryTitle,
            redirectParams: {
                type: ESearchSuggestItemType.REGION,
                geoId: pointInfo.geoId,
            },
            groupName: '',
        },
    };
};

export const transformSearchContext = (
    params: Omit<ITransformSearchContextRequestParams, 'vertical'>,
): CustomThunkAction<Promise<ITransformSearchContextResponse>> => {
    return async (dispatch): Promise<ITransformSearchContextResponse> => {
        dispatch(
            batchActions([
                setHotelsSearchFormToFieldAction({
                    selectedValue: false,
                    inputValue: '',
                    source: ESuggestSource.CROSS_SEARCH,
                }),
            ]),
        );

        const crossSearchInfo = await crossSearchProvider
            .provider()
            .transformSearchContext({
                ...params,
                vertical: 'hotels',
            });

        const {to} = crossSearchInfo;

        const toField: IHotelsSearchFormPointField = to
            ? getHotelsSuggestFromPointInfo(to)
            : {
                  selectedValue: false,
                  inputValue: '',
                  source: ESuggestSource.INPUT,
              };

        dispatch(batchActions([setHotelsSearchFormToFieldAction(toField)]));

        return crossSearchInfo;
    };
};
