import {ActionType, createAction} from 'typesafe-actions';

import {UpdateSearchInformationActivePayloadType} from './types';

import {SEARCH_INFORMATION_ACTIONS_TYPES} from './actionTypes';

/* Actions */
export const updateSearchInformation = createAction(
    SEARCH_INFORMATION_ACTIONS_TYPES.UPDATE_SEARCH_INFORMATION,
)<UpdateSearchInformationActivePayloadType>();

export const clearSearchInformation = createAction(
    SEARCH_INFORMATION_ACTIONS_TYPES.CLEAR_SEARCH_INFORMATION,
)<undefined>();

/* Action Types */
export type UpdateSearchInformationActionType = typeof updateSearchInformation;
export type ClearSearchInformationActionType = typeof clearSearchInformation;

export type SearchInformationActionsTypes = ActionType<
    UpdateSearchInformationActionType | ClearSearchInformationActionType
>;
