import {HotelSlugType, PermalinkType} from 'types/hotels/hotel/IHotel';
import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';
import {TGeoRegionSlug} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {DateLikeType} from 'utilities/dateUtils';

export interface ISearchInformation {
    adults: number;
    childrenAges: number[];
    checkinDate: DateLikeType;
    checkoutDate: DateLikeType;
    geoObject: {
        name: string;
        geoId?: GeoIdType;
        regionSlug?: TGeoRegionSlug;
    };
    hotel: {
        name: string;
        permalink: PermalinkType;
        hotelSlug: HotelSlugType;
    };
    activeSuggest?: IHotelsSuggest | null;
}

export type UpdateSearchInformationActivePayloadType =
    Partial<ISearchInformation>;
