import {createAction} from 'typesafe-actions';

import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {MapBoundsType} from 'types/common/ICoordinates';
import {ISearchHotelsInfo} from 'server/api/HotelsSearchAPI/types/ISearchHotels';

import {MAP_ACTION_TYPES} from './actionTypes';

export const clickMapMarker = createAction(
    MAP_ACTION_TYPES.CLICK_MAP_MARKER,
)<PermalinkType>();
export const selectMapMarker = createAction(MAP_ACTION_TYPES.SELECT_MAP_MARKER)<
    PermalinkType | undefined
>();
export const setMapBounds = createAction(
    MAP_ACTION_TYPES.SET_MAP_BOUNDS,
)<MapBoundsType>();
export const fillMap = createAction(
    MAP_ACTION_TYPES.FILL_MAP,
)<ISearchHotelsInfo>();
export const clearMapHotels = createAction(
    MAP_ACTION_TYPES.CLEAR_MAP_HOTELS,
)<undefined>();
export const resetMapToInitial = createAction(
    MAP_ACTION_TYPES.RESET_MAP_TO_INITIAL,
)<undefined>();
