import React from 'react';

import {setSnackbarInfo} from 'reducers/common/snackbar/actions';

import {getAttributionParams} from 'projects/depreacted/hotels/utilities/getAttributionParams/getAttributionParams';

import {hotelsFavoritesService} from 'serviceProvider';

import {
    changeIsOpenForNoMoreFavoritesModalAction,
    changeHotelsIsFavoriteOnSearchActions,
} from './actions';

export interface IAddFavoriteHotelParams {
    requestParams: any;
    message?: React.ReactElement | string;
}

export const addFavoriteHotel = ({
    requestParams: {permalink},
    message,
}: IAddFavoriteHotelParams): any => {
    return async dispatch => {
        try {
            const fillRequestParams: any = {
                permalink,
                ...getAttributionParams(),
            };

            const result = await hotelsFavoritesService
                .provider()
                .addFavoriteHotel(fillRequestParams);

            if (
                'error' in result &&
                result.error &&
                result.error === 'EAddToFavoritesError.HOTEL_LIMIT_EXCEEDED'
            ) {
                dispatch(changeIsOpenForNoMoreFavoritesModalAction(true));

                return;
            } else if ('error' in result && !result.error) {
                dispatch(
                    changeHotelsIsFavoriteOnSearchActions.success(permalink),
                );

                if (message) {
                    dispatch(
                        setSnackbarInfo({
                            lastAction: `${permalink}-add`,
                            hasCancellation: false,
                            message,
                            page: 'search',
                        }),
                    );
                }
            }
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnSearchActions.failure());
        }
    };
};

export const removeFavoriteHotel = ({permalink}: any): any => {
    return async dispatch => {
        try {
            const requestParams = {
                permalink,
                ...getAttributionParams(),
            };

            await hotelsFavoritesService
                .provider()
                .removeFavoriteHotels(requestParams);

            dispatch(changeHotelsIsFavoriteOnSearchActions.success(permalink));
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnSearchActions.failure());
        }
    };
};
