import {createReducer, ActionType} from 'typesafe-actions';

import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {EActiveHotelSource} from 'types/hotels/hotel/IActiveHotel';

import * as actions from 'reducers/depreacted/hotels/searchPage/selection/actions';

export interface IHotelSelection {
    activeHotelPermalink?: PermalinkType;
    activeHotelSource?: EActiveHotelSource;
    defaultActiveHotelPermalink?: PermalinkType;
    defaultActiveHotelSource?: EActiveHotelSource;
}

export default createReducer<IHotelSelection, ActionType<typeof actions>>({})
    .handleAction(actions.setDefaultActiveHotel, (state, {payload}) => ({
        ...state,
        defaultActiveHotelPermalink: payload ? payload.permalink : undefined,
        defaultActiveHotelSource: payload ? payload.source : undefined,
    }))
    .handleAction(actions.setActiveHotel, (state, {payload}) => ({
        ...state,
        activeHotelPermalink: payload ? payload.permalink : undefined,
        activeHotelSource: payload ? payload.source : undefined,
    }));
