import {createAction, ActionType} from 'typesafe-actions';

/* Types */
import {ISearchHotelsInfo} from 'server/api/HotelsSearchAPI/types/ISearchHotels';
import {TSortId} from 'types/hotels/search/ISortInfo';

import {ESortActionTypes} from './actionTypes';

/* Actions */

/* 1. SortInfo */
/* 1.1 Получение информации о сортировке из ответа поиска */
export const fillSortInfo = createAction(
    ESortActionTypes.FILL_SORT_INFO,
)<ISearchHotelsInfo>();

/* 2. SelectedSortId */
/* 2.1 Изменение текущей активной сортировки */
export const setActiveSort = createAction(ESortActionTypes.SET_SORT)<{
    id: TSortId;
    sortOrigin?: string;
}>();

/* 3. Reset */
/* 3.1 Сброс сортировки к начальному состоянию */
export const resetSortToInitial = createAction(
    ESortActionTypes.RESET_TO_INITIAL,
)();

/* Action Types */

/* 1. SortInfo */
export type TFillSortInfo = typeof fillSortInfo;

/* 2. SelectedSortId */
export type TSetActiveSort = typeof setActiveSort;

/* 3. Reset */
export type TResetSortToInitial = typeof resetSortToInitial;

export type TSortActions = ActionType<
    TFillSortInfo | TSetActiveSort | TResetSortToInitial
>;
