import {ActionType, createAction, createAsyncAction} from 'typesafe-actions';

import {
    ILogSearchSuggestPayload,
    IFetchSearchSuggestActionPayload,
    IFetchAndSelectSuggestActionPayload,
    IFetchSearchSuggestSuccessActionPayload,
} from './types';

import {SEARCH_SUGGEST_ACTION_TYPES} from './actionTypes';

/* Actions */
export const fetchSearchSuggestActions = createAsyncAction(
    SEARCH_SUGGEST_ACTION_TYPES.FETCH_SEARCH_SUGGEST,
    SEARCH_SUGGEST_ACTION_TYPES.FETCH_SEARCH_SUGGEST_SUCCESS,
    SEARCH_SUGGEST_ACTION_TYPES.FETCH_SEARCH_SUGGEST_FAIL,
)<
    IFetchSearchSuggestActionPayload,
    IFetchSearchSuggestSuccessActionPayload,
    undefined
>();

export const logSearchSuggestAction = createAction(
    SEARCH_SUGGEST_ACTION_TYPES.LOG_SEARCH_SUGGEST,
)<ILogSearchSuggestPayload>();

export const fetchAndSelectSearchSuggestAction = createAction(
    SEARCH_SUGGEST_ACTION_TYPES.FETCH_AND_SELECT_SEARCH_SUGGEST,
)<IFetchAndSelectSuggestActionPayload>();

export const resetSessionInfoSuggestAction = createAction(
    SEARCH_SUGGEST_ACTION_TYPES.RESET_SESSION_INFO_SEARCH_SUGGEST,
)();

/* Action Types */
export type FetchAndSelectSearchSuggestActionType =
    typeof fetchAndSelectSearchSuggestAction;
export type FetchSearchSuggestActionsTypes = typeof fetchSearchSuggestActions;
export type TResetSessionInfoSuggestAction =
    typeof resetSessionInfoSuggestAction;
export type TLogSearchSuggestAction = typeof logSearchSuggestAction;

export type SearchSuggestActionsTypes = ActionType<
    | FetchAndSelectSearchSuggestActionType
    | FetchSearchSuggestActionsTypes
    | TResetSessionInfoSuggestAction
    | TLogSearchSuggestAction
>;
