import {createReducer} from 'typesafe-actions';

import {
    fetchPromocodeAvailability,
    TPromocodeAvailabilityTypes,
} from './actions';

export interface IWelcomePromocodeReducer {
    isSet: boolean;
    data: boolean;
}

const initialState: IWelcomePromocodeReducer = {
    isSet: false,
    data: false,
};

export default createReducer<
    IWelcomePromocodeReducer,
    TPromocodeAvailabilityTypes
>(initialState)
    .handleAction(fetchPromocodeAvailability.request, () => ({
        isSet: false,
        data: false,
    }))
    .handleAction(fetchPromocodeAvailability.success, (_, {payload}) => ({
        isSet: true,
        data: payload,
    }))
    .handleAction(fetchPromocodeAvailability.failure, () => ({
        isSet: true,
        data: false,
    }));
