import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {fetchPromocodeAvailability} from './actions';

export const fetchWelcomePromocode =
    (): any =>
    async (dispatch, getState): Promise<void> => {
        const userInfo = getState().common.userInfo;
        const isAuth = isAuthUser(userInfo);

        if (!isAuth) {
            dispatch(fetchPromocodeAvailability.success(true));

            return;
        }

        dispatch(fetchPromocodeAvailability.request());

        try {
            const result = await Promise.resolve<any>(null);

            dispatch(
                fetchPromocodeAvailability.success(
                    result.first_order_promo_code_eligible,
                ),
            );
        } catch (e) {
            dispatch(fetchPromocodeAvailability.failure());
        }
    };
