import {Reducer} from 'typesafe-actions';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import loadableReducersStorage from 'reducers/utils/loadableReducers/loadableReducersStorage';

export default function loadableReducer(
    path: ELoadableReducer,
): Reducer<any, any> {
    return (state = {_INITIAL: true}, action): object => {
        const reducer = loadableReducersStorage[path];

        if (reducer) {
            return reducer(state?._INITIAL ? undefined : state, action);
        }

        return state;
    };
}
