import {Reducer} from 'typesafe-actions';

import {ELoadableReducer} from 'types/common/ELoadableReducer';

import loadableReducersStorage from 'reducers/utils/loadableReducers/loadableReducersStorage';

export default function preloadReducers(
    reducersInfo: [ELoadableReducer, Reducer<any, any>][],
): boolean {
    let hasAnyNewReducerPreloaded = false;

    reducersInfo.forEach(([reducerName, reducer]) => {
        if (!loadableReducersStorage[reducerName]) {
            loadableReducersStorage[reducerName] = reducer;

            hasAnyNewReducerPreloaded = true;
        }
    });

    return hasAnyNewReducerPreloaded;
}
