import {Saga, SagaMiddleware} from 'redux-saga';

/*
    runSaga is middleware.run function
    @see https://manukyan.dev/posts/2019-04-15-code-splitting-for-redux-and-optional-redux-saga/#redux-saga-code-splitting
*/
export function createSagaInjector(
    runSaga: SagaMiddleware['run'],
): (saga: Saga) => void {
    // Create a dictionary to keep track of injected sagas
    const injectedSagas = new Map();

    return (saga: Saga): void => {
        // We won't run saga if it is already injected
        if (injectedSagas.has(saga)) {
            return;
        }

        // Sagas return task when they executed, which can be used to cancel them
        const task = runSaga(saga);

        // Save the task if we want to cancel it in the future
        injectedSagas.set(saga, task);
    };
}
