import {getType} from 'typesafe-actions';
import {takeEvery, call, put} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {IBookOffer} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {TOfferInfoByTokenFailedPayload} from 'reducers/depreacted/hotels/bookAndPayPage/offerInfoByToken/types';

import {fetchOfferInfoByTokenAction} from 'reducers/depreacted/hotels/bookAndPayPage/offerInfoByToken/actions';

import sendMetrikaExtraVisitAndUserParams from 'projects/depreacted/hotels/utilities/metrika/sendMetrikaExtraVisitAndUserParams';
import {isUnknownAxiosError} from 'utilities/error';

import {hotelBookService} from 'serviceProvider';

const fetchOfferInfoByToken = function* (
    action: ReturnType<typeof fetchOfferInfoByTokenAction.request>,
): SagaIterator {
    const {payload} = action;

    try {
        const data: IBookOffer = yield call(
            hotelBookService.provider().fetchOfferInfo,
            payload,
        );

        sendMetrikaExtraVisitAndUserParams(data.extraVisitAndUserParams);

        yield put(fetchOfferInfoByTokenAction.success({data}));
    } catch (error) {
        const data = isUnknownAxiosError(error)
            ? error.response?.data
            : undefined;

        yield put(
            fetchOfferInfoByTokenAction.failure(
                data as TOfferInfoByTokenFailedPayload,
            ),
        );
    }
};

export default function* (): SagaIterator {
    yield takeEvery(
        getType(fetchOfferInfoByTokenAction.request),
        fetchOfferInfoByToken,
    );
}
