import {takeLatest, put, all, call} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {IHotelImagesRequestParams} from 'server/api/HotelSearchAPI/types/IHotelImages';

import {HOTEL_IMAGES_ACTION_TYPES} from 'reducers/depreacted/hotels/hotelPage/hotelImages/actionTypes';
import {getHotelImagesActions} from 'reducers/depreacted/hotels/hotelPage/hotelImages/actions';

import {getSearchParamsByReduxHotelState} from 'projects/depreacted/hotels/utilities/getHotelPageParams/getSearchParamsByReduxHotelState';

import {hotelSearchService} from 'serviceProvider';

const getHotelImagesRequest = function* (
    requestParams: IHotelImagesRequestParams,
) {
    const {data} = yield call(
        hotelSearchService.provider().getHotelImages,
        requestParams,
    );

    return data;
};

const getHotelImages = function* (
    action: ReturnType<typeof getHotelImagesActions.request>,
): SagaIterator {
    const {
        payload: {imageLimit, imageOffset},
    } = action;
    const {hotelSlug, parentRequestId} = yield call(
        getSearchParamsByReduxHotelState,
    );

    try {
        const hotelImages = yield call(getHotelImagesRequest, {
            imageLimit,
            hotelSlug,
            imageOffset,
            parentRequestId,
        });

        yield put(getHotelImagesActions.success(hotelImages));
    } catch {
        yield put(getHotelImagesActions.failure());
    }
};

export default function* (): SagaIterator {
    yield all([
        yield takeLatest(
            HOTEL_IMAGES_ACTION_TYPES.START_HOTEL_IMAGES_REQUEST,
            getHotelImages,
        ),
    ]);
}
