import {takeLatest, call, take, race, put, delay} from 'redux-saga/effects';
import _get from 'lodash/get';
import {SagaIterator} from 'redux-saga';

import {IHotelOffersInfo} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';

import {getHotelInfoOffersActions} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/actions';
import {HOTEL_INFO_ACTION_TYPES} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/actionTypes';

import {getSearchParamsByReduxHotelState} from 'projects/depreacted/hotels/utilities/getHotelPageParams/getSearchParamsByReduxHotelState';
import {
    getOfferAttributionParamsByLocation,
    getHotelOfferToken,
} from 'projects/depreacted/hotels/utilities/getHotelPageParams/getOfferAttributionParamsByLocation';
import sendMetrikaExtraVisitAndUserParams from 'projects/depreacted/hotels/utilities/metrika/sendMetrikaExtraVisitAndUserParams';
import {logError} from 'utilities/logger/logError';

import {hotelSearchService} from 'serviceProvider';

const HOTEL_OFFERS_POLLING_DELAY = 1000;

const getStartHotelOffersPolling = () =>
    function* (): SagaIterator {
        const offerSearchParamsByHotelInfo = yield call(
            getSearchParamsByReduxHotelState,
        );

        while (true) {
            try {
                const {data}: {data: IHotelOffersInfo} = yield call(
                    hotelSearchService.provider().getHotelOffers,
                    {
                        // На данный момент поля не отключены на бекенде, после отключения оторвать
                        ...offerSearchParamsByHotelInfo,
                        ...getOfferAttributionParamsByLocation(),
                        ...getHotelOfferToken(),
                    },
                );

                const isFinishedPollingHotelOffers = _get(
                    data,
                    'offerSearchProgress.finished',
                );

                yield put(getHotelInfoOffersActions.success(data));

                if (isFinishedPollingHotelOffers) {
                    sendMetrikaExtraVisitAndUserParams(
                        data.extraVisitAndUserParams,
                    );

                    yield put({
                        type: HOTEL_INFO_ACTION_TYPES.STOP_HOTEL_OFFERS_POLLING_REQUEST,
                    });

                    const hasUnknownMealType = data.mainOffers?.some(
                        offer => offer.mealType?.id === 'UNKNOWN',
                    );

                    if (hasUnknownMealType) {
                        logError({
                            message:
                                '[YATRAVEL] Неизвестный тип питания в предложении',
                            block: 'watchHotelOffers',
                        });
                    }
                } else {
                    yield delay(HOTEL_OFFERS_POLLING_DELAY);
                }
            } catch (e) {
                yield put({
                    type: getHotelInfoOffersActions.failure(),
                });
                yield put({
                    type: HOTEL_INFO_ACTION_TYPES.STOP_HOTEL_OFFERS_POLLING_REQUEST,
                });
            }
        }
    };

const watchHotelInfoOffersPolling = function* () {
    yield race({
        startAction: call(getStartHotelOffersPolling()),
        stopAction: take(
            HOTEL_INFO_ACTION_TYPES.STOP_HOTEL_OFFERS_POLLING_REQUEST,
        ),
    });
};

export default function* (): SagaIterator {
    yield takeLatest(
        HOTEL_INFO_ACTION_TYPES.START_HOTEL_OFFERS_POLLING_REQUEST,
        watchHotelInfoOffersPolling,
    );
}
