import {delay, call, takeLatest, take, race} from 'redux-saga/effects';
import {SagaIterator} from 'redux-saga';

import {HOTEL_INFO_ACTION_TYPES} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/actionTypes';

import updateLocationWithQuery from 'utilities/updateLocationWithQuery/updateLocationWithQuery';
import history from 'utilities/browserHistory/browserHistory';
import {getSearchParamsByReduxHotelState} from 'projects/depreacted/hotels/utilities/getHotelPageParams/getSearchParamsByReduxHotelState';
import {checkDifferenceBetweenQueryAndSearchParams} from 'projects/depreacted/hotels/pages/HotelPage/components/HotelPageSearchController/utilities/checkDifferenceBetweenQueryAndSearchParams';
import {getOfferSearchQueryParams} from 'projects/depreacted/hotels/utilities/getRequiredOfferSearchQuery/getRequiredOfferSearchQuery';

/* Constants */
const SYNC_SEARCH_PARAMS_DELAY = 500;

const syncParamsWithLocation = function* () {
    /* Delay after search request */
    yield delay(SYNC_SEARCH_PARAMS_DELAY);

    /* Sync params with location */
    if (history) {
        const {adults, childrenAges, checkinDate, checkoutDate} =
            yield getSearchParamsByReduxHotelState();

        const offerRequiredSearchParams = {
            adults,
            childrenAges,
            checkinDate,
            checkoutDate,
        };

        const hasDifferenceBetweenQueryAndSearchInfoParams =
            checkDifferenceBetweenQueryAndSearchParams({
                location: history.location,
                searchParams: offerRequiredSearchParams,
            });

        if (hasDifferenceBetweenQueryAndSearchInfoParams) {
            const offerRequiredSearchQueryParams = getOfferSearchQueryParams(
                offerRequiredSearchParams,
            );

            if (offerRequiredSearchQueryParams) {
                yield call(
                    updateLocationWithQuery,
                    offerRequiredSearchQueryParams,
                    history.location,
                    {
                        replace: true,
                        needSaveLocationState: true,
                    },
                );
            }
        }
    }
};

export const watchStartSyncSearchParamsWithLocation = function* () {
    yield race({
        startAction: call(syncParamsWithLocation),
        stopAction: take(HOTEL_INFO_ACTION_TYPES.STOP_HOTEL_INFO_ACTIONS),
    });
};

export default function* (): SagaIterator {
    yield takeLatest(
        HOTEL_INFO_ACTION_TYPES.SYNC_HOTEL_INFO_SEARCH_PARAMS_WITH_LOCATION,
        watchStartSyncSearchParamsWithLocation,
    );
}
