import {getType} from 'typesafe-actions';
import {
    delay,
    put,
    select,
    take,
    takeLatest,
    fork,
    cancel,
} from 'redux-saga/effects';
import {SagaIterator, Task} from 'redux-saga';

import {PermalinkType} from 'types/hotels/hotel/IHotel';
import {EActiveHotelSource} from 'types/hotels/hotel/IActiveHotel';

import {
    resetActiveHotel,
    setActiveHotel,
} from 'reducers/depreacted/hotels/searchPage/selection/actions';

import {getDefaultActiveHotelSource} from 'selectors/depreacted/hotels/search/selection/getDefaultActiveHotelSource';
import {getDefaultActiveHotelPermalink} from 'selectors/depreacted/hotels/search/selection/getDefaultActiveHotelPermalink';

function* handleResetSelection() {
    const defaultActiveHotelPermalink: PermalinkType | undefined = yield select(
        getDefaultActiveHotelPermalink,
    );
    const defaultActiveHotelSource: EActiveHotelSource | undefined =
        yield select(getDefaultActiveHotelSource);

    if (!defaultActiveHotelPermalink || !defaultActiveHotelSource) {
        yield put(setActiveHotel());

        return;
    }

    yield delay(200);
    yield put(
        setActiveHotel({
            permalink: defaultActiveHotelPermalink,
            source: defaultActiveHotelSource,
        }),
    );
}

function* handleSelection() {
    try {
        const resetSelectionTask: Task = yield fork(handleResetSelection);

        yield take(getType(setActiveHotel));
        yield cancel(resetSelectionTask);
    } catch (e) {}
}

export default function* (): SagaIterator {
    yield takeLatest(getType(resetActiveHotel), handleSelection);
}
