import axios, {AxiosInstance, AxiosPromise, AxiosRequestHeaders} from 'axios';

/* Constants */
import {HOTELS_BASE_API} from 'projects/depreacted/hotels/constants/hotelsAPI';

/* Types */
import {
    ICancelOrderParams,
    IOrderRefundableInfoParams,
} from 'reducers/depreacted/hotels/bookAndPayPage/orderCancelAndRefundableInfo/types';

import {ICancelOrderPayload} from 'reducers/depreacted/hotels/bookAndPayPage/orderCancelAndRefundableInfo/actions';

class CancelOrderAPIClient {
    protected axiosInstance: AxiosInstance;

    constructor() {
        this.axiosInstance = axios.create({
            baseURL: HOTELS_BASE_API,
        });
    }

    fetchOrderRefundableInfo = (orderId: string): AxiosPromise => {
        const requestQuery: IOrderRefundableInfoParams = {orderId};

        return this.axiosInstance.get('getOrderRefundableInfo', {
            params: requestQuery,
        });
    };

    cancelOrder = (
        payload: ICancelOrderPayload,
        headers: AxiosRequestHeaders = {},
    ): AxiosPromise => {
        const {orderId, refundToken} = payload;
        const requestBody: ICancelOrderParams = {
            orderId,
            refundToken,
        };

        return this.axiosInstance.post('cancelOrder', requestBody, {headers});
    };
}

export default CancelOrderAPIClient;
