import _cloneDeep from 'lodash/cloneDeep';
import _mapValues from 'lodash/mapValues';

import {IBookFormValues, IBookGuest} from 'types/hotels/book/IBookFormValues';

function trimGuest(guest: IBookGuest): IBookGuest {
    return _mapValues(guest, (value): any => {
        if (value && typeof value === 'string') {
            return value.trim();
        }

        return value;
    });
}

export const createNormalizedGuestsFormCopy = (
    formValues: IBookFormValues,
): IBookFormValues => {
    const formValuesCopy = _cloneDeep(formValues);
    const {contacts, adult = [], children = []} = formValuesCopy;

    formValuesCopy.adult = adult.map(trimGuest);
    formValuesCopy.children = children.map(guest => ({
        ...trimGuest(guest),
        age: guest.age,
    }));

    formValuesCopy.contacts = {
        validationKey: 'contacts',
        email: contacts?.email?.trim(),
        phone: contacts?.phone?.trim(),
    };

    return formValuesCopy;
};
