import deviceTypeSelector from 'selectors/common/deviceTypeSelector';
import featuresSelector from 'selectors/common/featuresSelector';
import environmentConfigSelector from 'selectors/common/environmentConfigSelector';
import {getUserInfo} from 'selectors/common/userInfoSelector';
import isYandexoidSelector from 'selectors/common/isYandexoid';
import {isFromXredirectSelector} from 'selectors/common/isFromXredirectSelector';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    deviceType: deviceTypeSelector,
    features: featuresSelector,
    environmentConfig: environmentConfigSelector,
    userIsAuth: state => isAuthUser(getUserInfo(state)),
    userHasPlusInfo: state => Boolean(getUserInfo(state).plusInfo),
    subscribeStatusFetched: state =>
        Boolean(state.common.subscription.status.isFetched),
    needToShowBug: isYandexoidSelector,
    isFromXredirect: isFromXredirectSelector,
});
