import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {TUserInfo} from 'reducers/common/commonReducerTypes';

import {getUserInfo} from 'selectors/common/userInfoSelector';
import {getUserUndeadMailCount} from 'selectors/common/getUserUndeadMailCount';

export interface IUserFullInfoSelector {
    userInfo: TUserInfo;
    unreadMailCount: number;
}

export default createStructuredSelector<StoreInterface, IUserFullInfoSelector>({
    userInfo: getUserInfo,
    unreadMailCount: getUserUndeadMailCount,
});
