import _getFp from 'lodash/fp/get';
import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {IOrderCancelAndRefundableInfo} from 'reducers/depreacted/hotels/bookAndPayPage/orderCancelAndRefundableInfo/reducer';

export type GetOrderCancelAndRefundableInfoType = (
    store: StoreInterface,
) => IOrderCancelAndRefundableInfo;
export interface IOrderCancelAndRefundableSelector {
    orderCancelAndRefundableInfo: IOrderCancelAndRefundableInfo;
}

export const getOrderCancelAndRefundableInfo: GetOrderCancelAndRefundableInfoType =
    _getFp('hotels.bookAndPay.orderCancelAndRefundableInfo');

export default createStructuredSelector<
    StoreInterface,
    IOrderCancelAndRefundableSelector
>({
    orderCancelAndRefundableInfo: getOrderCancelAndRefundableInfo,
});
