import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';
import {IGeoRegionInfoReducer} from 'reducers/depreacted/hotels/geoRegionPage/reducer';

import nonceSelector from 'selectors/common/nonceSelector';

/* Getters */
export const getGeoRegionInfo = (
    store: StoreInterface,
): IGeoRegionInfoReducer => store.hotels.geoRegionPage;

const skipSnippetFormSelector = (store: StoreInterface): boolean =>
    Boolean(store.common.experiments.hotelsSkipSnippetForm);

/* Types */
export interface IGeoRegionPageSelector {
    skipSnippetForm: ReturnType<typeof skipSnippetFormSelector>;
    geoRegionInfo: ReturnType<typeof getGeoRegionInfo>;
    schemaNonce: ReturnType<typeof nonceSelector>;
}

/* Selectors */
export default createStructuredSelector<StoreInterface, IGeoRegionPageSelector>(
    {
        skipSnippetForm: skipSnippetFormSelector,
        geoRegionInfo: getGeoRegionInfo,
        schemaNonce: nonceSelector,
    },
);
