import {createSelector} from 'reselect';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {IHotelRoom, TRoomId} from 'types/hotels/offer/IHotelRoom';
import {IHotelBoyMetaRoomWithOffers} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';

import {IHotelInfoReducer} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/reducer';

import {getHotelInfo} from 'selectors/depreacted/hotels/hotel/mainTab/getHotelInfo';

const filterRoomOfferByRoomId = (
    offers: IHotelOffer[],
    roomId: TRoomId,
): IHotelOffer[] => offers.filter(offer => roomId === offer.roomId);

const createRoomWithOffersListByRooms = (
    offers: IHotelOffer[],
    rooms: IHotelRoom[],
): IHotelBoyMetaRoomWithOffers[] =>
    rooms.map(room => ({
        ...room,
        offers: filterRoomOfferByRoomId(offers, room.id),
    }));

export default createSelector(
    getHotelInfo,
    (hotelInfo: IHotelInfoReducer): IHotelBoyMetaRoomWithOffers[] => {
        const {data} = hotelInfo;

        if (data && data.offersInfo) {
            const {rooms} = data.offersInfo;

            if (rooms) {
                return createRoomWithOffersListByRooms(
                    data.offersInfo.mainOffers || [],
                    rooms,
                );
            }
        }

        return [];
    },
);
