import {createStructuredSelector} from 'reselect';

/* Types */
import {StoreInterface} from 'reducers/storeTypes';

/* Getters and Selectors */
import nonceSelector from 'selectors/common/nonceSelector';

import {getHotelInfo, HotelInfoSelectorType} from './mainTab/getHotelInfo';

/* Types */
export interface IHotelPageSelector {
    hotelInfo: HotelInfoSelectorType;
    schemaNonce: string;
}

/* Selectors */
export default createStructuredSelector<StoreInterface, IHotelPageSelector>({
    hotelInfo: getHotelInfo,
    schemaNonce: nonceSelector,
});
