import _getFp from 'lodash/fp/get';

import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';

import {StoreInterface} from 'reducers/storeTypes';

export type GetHotelSearchParamsType = (
    store: StoreInterface,
) => IRequiredOfferParams;

export const getHotelSearchParams: GetHotelSearchParamsType = _getFp(
    'hotels.hotelPage.hotelInfo.data.searchParams',
);

export type HotelSearchParamsSelectorType = ReturnType<
    typeof getHotelSearchParams
>;
