import {createSelector} from 'reselect';
import _getFp from 'lodash/fp/get';

import {IHotelOffer} from 'types/hotels/offer/IHotelOffer';
import {HotelOffersFiltersType} from 'reducers/depreacted/hotels/hotelPage/hotelInfo/types';

import {StoreInterface} from 'reducers/storeTypes';

type GetHotelOffersType = (store: StoreInterface) => IHotelOffer[];

export const getHotelOffers: GetHotelOffersType = _getFp(
    'hotels.hotelPage.hotelOffers.data.offers',
);

type GetHotelOfferFiltersType = (
    store: StoreInterface,
) => HotelOffersFiltersType;

export const getHotelOffersFilters: GetHotelOfferFiltersType = _getFp(
    'hotels.hotelPage.hotelOffers.filters',
);

/*
 * Filters
 * TODO: Перенести фильтры в отельные утилиты
 */
type OfferFilterType = (offer: IHotelOffer) => boolean;

const isOfferWithMeal: OfferFilterType = (offer: IHotelOffer) =>
    Boolean(offer.mealType && offer.mealType.id !== 'RO');

const isOfferWithRefund: OfferFilterType = (offer: IHotelOffer) =>
    Boolean(offer.cancellationInfo?.hasFreeCancellation);

const hotelFilteredOffersSelector = createSelector(
    (state: StoreInterface) => getHotelOffers(state),
    (state: StoreInterface) => getHotelOffersFilters(state),
    (offers: IHotelOffer[], filters: HotelOffersFiltersType) => {
        const filtersToApply: OfferFilterType[] = [];

        if (filters['meal']) {
            filtersToApply.push(isOfferWithMeal);
        }

        if (filters['refund']) {
            filtersToApply.push(isOfferWithRefund);
        }

        if (offers && filtersToApply.length > 0) {
            return offers.filter(offer =>
                filtersToApply.every(filter => filter(offer)),
            );
        }

        return offers;
    },
);

export type HotelFilteredOffersSelectorType = ReturnType<
    typeof hotelFilteredOffersSelector
>;

export default hotelFilteredOffersSelector;
