import _getFp from 'lodash/fp/get';

import {IFeatureRatingInfo} from 'types/hotels/hotel/IFeatureRating';

import {StoreInterface} from 'reducers/storeTypes';

export type GetHotelFeatureRatings = (
    store: StoreInterface,
) => IFeatureRatingInfo[];

export const getHotelFeatureRatings: GetHotelFeatureRatings = _getFp(
    'hotels.hotelPage.hotelInfo.data.ratingsInfo.featureRatings',
);

export type HotelFeatureRatingsSelectorType = ReturnType<
    typeof getHotelFeatureRatings
>;
