import {createStructuredSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

import {
    getHotelFeatureRatings,
    HotelFeatureRatingsSelectorType,
} from './getHotelFeatureRatings';
import {totalReviewCountSelector} from './totalReviewsCountSelector';
import {getHotelReviews, HotelReviewsSelectorType} from './getHotelReviews';

export interface IHotelFeatureRatingsSelector {
    hotelReviews: HotelReviewsSelectorType;
    hotelFeatureRatingsInfo: HotelFeatureRatingsSelectorType;
    totalReviewCount: number;
}

export default createStructuredSelector<
    StoreInterface,
    IHotelFeatureRatingsSelector
>({
    hotelReviews: getHotelReviews,
    hotelFeatureRatingsInfo: getHotelFeatureRatings,
    totalReviewCount: totalReviewCountSelector,
});
