import {createSelector} from 'reselect';

import {StoreInterface} from 'reducers/storeTypes';

/* Getters */
import {getHotelReviews, GetHotelReviewsType} from './getHotelReviews';

export const totalReviewCountSelector = createSelector<
    StoreInterface,
    ReturnType<GetHotelReviewsType>,
    number
>(getHotelReviews, (hotelReviews: ReturnType<GetHotelReviewsType>): number => {
    const {
        data: {totalTextReviewCount, keyPhrases},
        activeKeyPhrase,
    } = hotelReviews;

    let reviewsLimit = totalTextReviewCount;

    if (activeKeyPhrase) {
        const item = keyPhrases.find(
            keyPhrase => keyPhrase.name === activeKeyPhrase,
        );
        if (item) {
            reviewsLimit = item.reviewCount;
        }
    }

    return reviewsLimit;
});
