import {createSelector} from 'reselect';

import {
    ActiveFilterAtomsType,
    IBasicFilterGroup,
    IRangePriceFilter,
} from 'types/hotels/search/IFiltersInfo';

import {getHotelsCurrentFilters} from 'selectors/depreacted/hotels/search/filters/hotelsFiltersSelector';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';

import {flatHotelFilters} from 'projects/depreacted/hotels/utilities/filters/flatHotelFilters';

const calculateTotalPriceFilter = (priceFilter?: IRangePriceFilter): number => {
    if (priceFilter) {
        const {minValue, maxValue, minPriceEstimate, maxPriceEstimate} =
            priceFilter;

        if (minValue !== minPriceEstimate || maxValue !== maxPriceEstimate) {
            return 1;
        }
    }

    return 0;
};

const calculateTotalFilterGroups = (
    detailedFilters?: IBasicFilterGroup[],
    activeFilterAtoms?: ActiveFilterAtomsType,
): number => {
    if (activeFilterAtoms && detailedFilters && detailedFilters.length) {
        return detailedFilters.reduce(
            (total: number, filterGroup) =>
                filterGroup.items.reduce((groupTotal: number, filter) => {
                    const {atoms} = filter;

                    if (
                        atoms.length &&
                        atoms.every(atom => activeFilterAtoms[atom])
                    ) {
                        return groupTotal + 1;
                    }

                    return groupTotal;
                }, total),
            0,
        );
    }

    return 0;
};

export const getTotalActiveFilters = createSelector(
    [getHotelsCurrentFilters, deviceTypeSelector],
    currentFilters => {
        const {priceFilter, activeFilterAtoms, detailedFiltersBatches} =
            currentFilters;

        const totalPriceFilter = calculateTotalPriceFilter(priceFilter);
        const totalActiveTotalFilterGroups = calculateTotalFilterGroups(
            flatHotelFilters(detailedFiltersBatches),
            activeFilterAtoms,
        );

        return totalPriceFilter + totalActiveTotalFilterGroups;
    },
);
