import {IFullFilters} from 'types/hotels/search/IFiltersInfo';
import {TSelector} from 'src/redux/types/TSelector';

import {IHotelsFiltersReducer} from 'reducers/depreacted/hotels/searchPage/filters/reducer';

export type GetFiltersType = TSelector<IHotelsFiltersReducer>;

export const getHotelsFilters: GetFiltersType = state =>
    state.hotels.searchHotelsPage.filters;

export const getHotelsCurrentFilters: TSelector<IFullFilters> = state =>
    getHotelsFilters(state).currentFilters;

export const getHotelsPermanentFilters: TSelector<IFullFilters> = state =>
    getHotelsFilters(state).permanentFilters;
