import {ESearchBanner} from 'reducers/depreacted/hotels/searchPage/search/reducer';

import {getHasPromocodeTaxi} from 'selectors/depreacted/hotels/search/searchHotels/getHasPromocodeTaxi';
import {getSearchInfo} from 'selectors/depreacted/hotels/search/searchHotels/getSearchInfo';
import {getSortInfo} from 'selectors/depreacted/hotels/search/sort/getSortInfo';
import mirCashbackSearchIsExpandedSelector from 'selectors/common/togglers/mirCashbackSearchIsExpandedSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';
import {hotelsFiltersSelector} from 'projects/depreacted/hotels/pages/SearchPage/components/HotelsFilters/selectors/hotelsFiltersSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    hasSearchData: state => Boolean(getSearchInfo(state).data),
    hasBoyOffers: state => getSearchInfo(state).data?.hasBoyOffers,
    isLoading: state => {
        const searchInfo = getSearchInfo(state);

        return (
            searchInfo.isLoading ||
            !searchInfo.data?.offerSearchProgress.finished
        );
    },
    hasMirBanner: state =>
        getSearchInfo(state).data?.searchBannerType === ESearchBanner.MIR,
    hasPromoTaxi: getHasPromocodeTaxi,
    hasSort: state =>
        Boolean(getSortInfo(state).sortInfo?.availableSortTypeGroups?.length),
    isMirCashbackExpanded: mirCashbackSearchIsExpandedSelector,
    filters: hotelsFiltersSelector,
    experiments: experimentsSelector,
});
