import {createSelector} from 'reselect';

import {getOfferSearchParams} from 'selectors/depreacted/hotels/search/searchHotels/getOfferSearchParams';

import {getTotalNights as getTotalNightsHelper} from 'projects/depreacted/hotels/utilities/calculateTotalNights/calculateTotalNights';

export const getTotalNights = createSelector(
    [getOfferSearchParams],
    offerSearchParams => {
        return offerSearchParams
            ? getTotalNightsHelper(
                  offerSearchParams.checkinDate,
                  offerSearchParams.checkoutDate,
              )
            : 0;
    },
);
