import {ESearchFormFieldName} from 'components/SearchForm/types';

import getHotelsSearchSuggest from 'selectors/common/hotelsSuggestSelector';
import {getSearchInformation} from 'selectors/depreacted/hotels/search/searchInformation/searchInformationSelector';
import featuresSelector from 'selectors/common/featuresSelector';
import {getUserGeoLocation} from 'selectors/common/userInfoSelector';
import {toFieldSelector} from 'selectors/depreacted/hotels/searchForm/toFieldSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

export default createTypedStructuredSelector({
    toField: toFieldSelector,
    startDateField: state =>
        state.hotels.searchForm[ESearchFormFieldName.START_DATE],
    endDateField: state =>
        state.hotels.searchForm[ESearchFormFieldName.END_DATE],
    adultsField: state => state.hotels.searchForm.adults,
    childrenAgesField: state => state.hotels.searchForm.childrenAges,
    searchSuggests: getHotelsSearchSuggest,
    searchInformation: getSearchInformation,
    enableDebugHotelProdOffers: state =>
        Boolean(featuresSelector(state).enableDebugHotelProdOffers),
    userGeoLocation: getUserGeoLocation,
});
