import {ITransformSearchContextRequestParams} from 'server/api/TransformSearchApi/types/ITransformSearchContextRequestParams';
import {ITransformSearchContextResponse} from 'server/api/TransformSearchApi/types/ITransformSearchContextResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {ICrossSearchService} from 'server/services/CrossSearchService/CrossSearchService';

export class CrossSearchBrowserProvider
    extends BrowserHttpClient
    implements ICrossSearchService
{
    constructor() {
        super({baseURL: '/api/crossSearch/'});
    }

    transformSearchContext = (
        params: ITransformSearchContextRequestParams,
    ): Promise<ITransformSearchContextResponse> => {
        return this.get<ITransformSearchContextResponse>(
            'transformSearchContext',
            {
                params,
            },
        );
    };
}

export const crossSearchBrowserProvider = new CrossSearchBrowserProvider();
