import IExperimentsService from 'server/services/ExperimentsService/types/IExperimentsService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserExperimentsProvider} from './browserExperimentsProvider';

export const experimentsProvider = {
    provider(container?: IDependencies): IExperimentsService {
        return getProvider<'experimentsService', IExperimentsService>(
            browserExperimentsProvider,
            'experimentsService',
        )(container);
    },
};
