import {IGeoLocation} from 'reducers/common/commonReducerTypes';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IGeobaseService} from 'server/services/GeobaseService/GeobaseService';

export class BrowserGeobaseProvider
    extends BrowserHttpClient
    implements IGeobaseService
{
    constructor() {
        super({baseURL: '/api/common/geobase'});
    }

    getUserGeoLocation = (): Promise<Required<IGeoLocation>> => {
        return this.get<Required<IGeoLocation>>('getUserGeoLocation');
    };
}

export const browserGeobaseProvider = new BrowserGeobaseProvider();
