import _get from 'lodash/get';

import {IDependencies} from 'server/getContainerConfig';

export function getProvider<ServiceKey extends keyof IDependencies, IService>(
    browserProvider: IService,
    serviceKey: ServiceKey,
): (container?: IDependencies) => IService {
    return container => {
        let provider;

        if (__SERVER__) {
            provider = _get(container, `cradle.${serviceKey}`, null);
        } else {
            provider = browserProvider;
        }

        return provider;
    };
}
