import {
    HOTELS_BASE_API,
    OFFER_INFO_BY_TOKEN as OFFER_INFO_BY_TOKEN_API,
    CREATE_ORDER as CREATE_ORDER_API,
    ESTIMATE_DISCOUNT as ESTIMATE_DISCOUNT_API,
    REMOVE_ORDER as REMOVE_ORDER_API,
    POLLING_ORDER as POLLING_ORDER_API,
    START_PAYMENT as START_PAYMENT_API,
    POLLING_ORDER_STATUS as POLLING_ORDER_STATUS_API,
    GET_TEST_BOOK_OFFER_TOKEN,
    CHECK_VOUCHER,
} from 'projects/depreacted/hotels/constants/hotelsAPI';

import {
    ICreateOrderRequest,
    ICreateOrder,
} from 'types/hotels/book/ICreateOrder';
import {
    IApplyPromoCodesRequest,
    IAppliedPromoCodesInfo,
} from 'types/hotels/book/IApplyPromoCodes';
import {IOrder, IOrderParams} from 'server/api/HotelsBookAPI/types/IOrder';
import {
    IStartPayment,
    IStartPaymentParams,
} from 'server/api/HotelsBookAPI/types/IStartPayment';
import {
    IBookOffer,
    IFetchBookOfferParams,
} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IOrderStatusResponse} from 'server/api/HotelsBookAPI/types/IOrderResponse';
import {
    ITestBookOfferTokenRequestParams,
    ITestBookOfferTokenResponse,
} from 'server/api/HotelsBookAPI/types/ITestBookOfferToken';
import {
    ICheckVoucher,
    ICheckVoucherParams,
} from 'server/api/HotelsBookAPI/types/ICheckVoucher';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';
import {ITokenHeader} from 'utilities/csrfToken/prepareTokenHeader';

import {IHotelsBookService} from 'server/services/HotelsServices/HotelsBookService';

export class BrowserHotelBookProvider
    extends BrowserHttpClient
    implements IHotelsBookService
{
    constructor() {
        super({baseURL: HOTELS_BASE_API});
    }

    fetchOfferInfo = (params: IFetchBookOfferParams): Promise<IBookOffer> =>
        this.get(OFFER_INFO_BY_TOKEN_API, {params});

    getOrder = (params: IOrderParams): Promise<IOrder> =>
        this.get(POLLING_ORDER_API, {params});

    getOrderStatus = (params: IOrderParams): Promise<IOrderStatusResponse> =>
        this.get(POLLING_ORDER_STATUS_API, {params});

    createOrder = (
        order: ICreateOrderRequest,
        headers: ITokenHeader,
    ): Promise<ICreateOrder> =>
        this.post<ICreateOrder>(CREATE_ORDER_API, order, {headers});

    removeOrder = (id: string, headers: ITokenHeader): Promise<void> =>
        this.delete<void>(`${REMOVE_ORDER_API}/${id}`, {headers});

    startPayment = (
        data: IStartPaymentParams,
        headers: ITokenHeader,
    ): Promise<IStartPayment> =>
        this.post<IStartPayment>(START_PAYMENT_API, data, {headers});

    estimateDiscount = (
        promoCodes: IApplyPromoCodesRequest,
    ): Promise<IAppliedPromoCodesInfo> => {
        return this.post<IAppliedPromoCodesInfo>(
            ESTIMATE_DISCOUNT_API,
            promoCodes,
        );
    };

    checkVoucher = (
        params: ICheckVoucherParams,
        abortParams?: {signal: AbortSignal},
    ): Promise<ICheckVoucher> => {
        return this.get<ICheckVoucher>(CHECK_VOUCHER, {params, ...abortParams});
    };

    getHotelsTestContextToken(
        params: ITestBookOfferTokenRequestParams,
    ): Promise<ITestBookOfferTokenResponse> {
        return this.get(GET_TEST_BOOK_OFFER_TOKEN, {params});
    }
}

export const browserHotelBookProvider = new BrowserHotelBookProvider();
