import {IHotelsBookService} from 'server/services/HotelsServices/HotelsBookService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserHotelBookProvider} from './browserHotelBookProvider';

export const hotelBook = {
    provider(container?: IDependencies): IHotelsBookService {
        return getProvider<'hotelsBookService', IHotelsBookService>(
            browserHotelBookProvider,
            'hotelsBookService',
        )(container);
    },
};
